; ******************************************************
;        DC mBOT - BackUp and Restore
; ******************************************************
; [Aliases]
alias _B.Write {
  if (%BU.Dir == $null) { .writeini $DC.Dir(BackUp\mBOT.ini) $1 $2 $iif($3 != $null, $3, NotSet) }
  else { .writeini $DC.Dir(BackUp\ $+ %BU.Dir $+ \mBOT.ini) $1 $2 $iif($3 != $null, $3, NotSet) }
}
alias _B.Reads return $readini($DC.Dir(mBOT\Backup.ini),$1,$2)
alias _B.Read {
  if (%BU.Res == $null) return $readini($DC.Dir(BackUp\mBOT.ini),$1,$2)
  else return $readini($DC.Dir(BackUp\ $+ %BU.Res $+ \mBOT.ini),$1,$2)
}
alias Save.Daily.BackUp {
  if (%Daily.Done == OK) halt
  set -u60 %Daily.Done OK
  set -u5 %Daily.BU ON
  .timer.Save.Daily.BackUp off
  if ($server != $null) { Check.Sort C | amsg Creating Daily Backup Files... }
  else { Check.Sort C | halt }
  .timer.Save.Daily.BackUp 0:00 1 1 /Save.Daily.BackUp
}
alias -l Close.All.Dialogs {
  if ($dialog(DC-mBOT)) { dialog -c DC-mBOT }
  if ($dialog(BotPro)) { dialog -c BotPro }
  if ($dialog(Member-Manager)) { dialog -c Member-Manager }
  if ($dialog(Extra-Settings)) { dialog -c Extra-Settings }
  if ($dialog(xSeen)) { dialog -c xSeen }
  if ($dialog(MyOper)) { dialog -c MyOper }
  if ($dialog(ConMgr)) { dialog -c ConMgr }
  if ($dialog(Logs)) { dialog -c Logs }
  if ($dialog(Talk.Bot)) { dialog -c Talk.Bot }
  if ($dialog(mBAbout)) { dialog -c mBAbout }
  if ($dialog(SB.Settings)) { dialog -c SB.Settings }
}
alias Auto.BU {
  if ($_B.Reads(X,Auto) == ON) { .writeini $DC.Dir(mBOT\Backup.ini) X Auto OFF | .timer.Save.Daily.BackUp Off }
  else { .writeini $DC.Dir(mBOT\Backup.ini) X Auto ON | .timer.Save.Daily.BackUp 0:00 1 1 /Save.Daily.BackUp }
}
alias Sort.BU {
  if ($_B.Reads(X,Sort) == ON) { .writeini $DC.Dir(mBOT\Backup.ini) X Sort OFF }
  else { .writeini $DC.Dir(mBOT\Backup.ini) X Sort ON }
}
alias DC.BackUp { dialog $iif($dialog(DC.BackUp), -v,-m) DC.BackUp DC.BackUp }
alias BU.Date.Rec {
  if ($1) {
    var %f = 0
    while (%f <= 200) {
      if (!$_B.Reads(Date,n $+ %f)) {
        .writeini $DC.Dir(mBOT\Backup.ini) Date $+(n,%f) $1
        .writeini $DC.Dir(mBOT\Backup.ini) X Last $1
        break
      }
      inc %f
    }
    unset %f
  }
}
alias -l DC.BU.Res.Combo {
  var %x = 0
  while (%x <= 100) {
    if ($_B.Reads(Date,n $+ %x) != $null) { did -a DC.BackUp 26 $ifmatch }
    inc %x
  }
}
alias -l DC.BU.Removing {
  var %x = 0
  while (%x <= 100) {
    if ($_B.Reads(Date,n $+ %x) == $1) {
      .remini $DC.Dir(mBOT\Backup.ini) Date n $+ %x
      if ($_B.Reads(X,Last) == $1) { .remini $DC.Dir(mBOT\Backup.ini) X Last }
      DC.BU.Res.Combo
      break
    }
    inc %x
  }
}
alias DC.BackUp.Rem {
  var %Result = $input(Are you sure? $+ $crlf $+ You want to deleting all Backups?,wyvg,Removing Backups)
  if (%Result == $yes) {
    if ($isdir($noqt($Bdir)) == $true) { .delete $noqt($Bdir) }
    .remini $DC.Dir(mBOT\Backup.ini) X Last
    .remini $DC.Dir(mBOT\Backup.ini) Date
    echo -at 2***3 (BackUp)1 All BackUp Files/Folders has been successfully removed!
  }
  else { halt }
}
alias Open.Go.Button {
  if ($dialog(DC.BackUp)) {
    if ($did(DC.BackUp,8).text == Start (3)) { did -ra DC.BackUp 8 Start (2) }
    elseif ($did(DC.BackUp,8).text == Start (2)) { did -ra DC.BackUp 8 Start (1) }
    elseif ($did(DC.BackUp,8).text == Start (1)) { did -ra DC.BackUp 8 Start (0) }
    elseif ($did(DC.BackUp,8).text == Start (0)) { did -ra DC.BackUp 8 &Start | .timer.Open.B Off | did -e DC.BackUp 8 }
  }
  else { .timer.Open.B Off }
}
alias -l Check.Sort {
  if ($1) {
    if (!$isdir($DC.Dir(BackUp))) { .mkdir $DC.Dir(BackUp) }
    if ($1 == R) goto Restore
    if ($1 == C) {
      if ($dialog(DC.BackUp)) { did -ra DC.BackUp 13 Checking Sort Folder... }
      if ($_B.Reads(X,Sort) == ON) {
        set -u5 %Date.tmp $replace($date,$chr(32),$chr(45),$chr(46),$chr(45),$chr(95),$chr(45),$chr(47),$chr(45),$chr(92),$chr(45))
        if (!$exists($DC.Dir(BackUp\ $+ %Date.tmp))) { .mkdir $DC.Dir(BackUp\ $+ %Date.tmp $+ ) }
        set -u20 %BU.Dir %Date.tmp
        .timer.xx 1 2 /C.BackUp
      }
      else { unset %BU.Dir | .timer.xx 1 2 /C.BackUp }
      halt
    }
    :Restore
    if ($1 == R) { .timer.xx 1 2 /R.BackUp }
    halt
  }
}
alias -l C.BackUp {
  Backup.Save
  if ($dialog(DC.BackUp)) { did -ra DC.BackUp 13 Checking Latest BackUp's Date... }
  ; Set BackUp Info
  if (%Daily.BU == ON) goto _Go
  if (%Replace.BackUp == ON) goto Go
  if ($_B.Reads(X,Last) != $null) {
    if ($replace($date,$chr(32),$chr(45),$chr(46),$chr(45),$chr(95),$chr(45),$chr(47),$chr(45),$chr(92),$chr(45)) == $_B.Reads(X,Last)) {
      if ($dialog(DC.BackUp)) { did -ve DC.BackUp 14,15,16,17,18,19,20,22,23 | did -hb DC.BackUp 8,9,10,11,26 }
      if ($dialog(DC.BackUp)) { did -ve DC.BackUp 7 | did -ra DC.BackUp 13 The Latest BackUp is for Today! | set %BU.Today 1 }
      halt
    }
  }
  :Go
  ; Recording Backup Date In The Backup's Folder (It'll Use For Backup Restore)
  $_B.Write(BackUp,Date,$replace($date,$chr(32),$chr(45),$chr(46),$chr(45),$chr(95),$chr(45),$chr(47),$chr(45),$chr(92),$chr(45)))

  ; Saving Settings/Files
  ; mBOT Main Settings

  if ($dialog(DC.BackUp)) { did -ve DC.BackUp 15 }

  :_Go
  if ($_B.Reads(Settings,Main) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($dialog(DC.BackUp) != $null) { did -ra DC.BackUp 13 Saving mBOT Settings... }
    $_B.Write(mBOT,Bot,%Enable.DC.mBOT)
    $_B.Write(mBOT,Owner,%Owner-DC.mBOT)
    $_B.Write(mBOT,Co-Owner,%Co.Owner-DC.mBOT)
    $_B.Write(mBOT,Triggers,%DC-mBOT-Custom-Trigger)
    $_B.Write(mBOT,Trigger,%Trigger)
    $_B.Write(mBOT,Ignore-T,%DC-mBOT-UIgnore.Times)
    $_B.Write(mBOT,Ignore-B,%DC-mBOT-UIgnore.Ban)
    $_B.Write(mBOT,Btype,%Bot-BanTypes)
    $_B.Write(mBOT,Notice.Cmds,%Notice.Cmds)
    $_B.Write(mBOT,Notice.Pass,%Notice.Pass)

    ; mBOT Cmds
    $_B.Write(Cmds,Op,%DC-mBOT-Op-Cmd)
    $_B.Write(Cmds,Voice,%DC-mBOT-Voice-Cmd)
    $_B.Write(Cmds,Ban,%DC-mBOT-Ban-Cmd)
    $_B.Write(Cmds,DeOp,%DC-mBOT-DeOp-Cmd)
    $_B.Write(Cmds,DeVoice,%DC-mBOT-DeVoice-Cmd)
    $_B.Write(Cmds,UnBan,%DC-mBOT-UnBan-Cmd)
    $_B.Write(Cmds,Kick,%DC-mBOT-Kick-Cmd)
    $_B.Write(Cmds,Kb,%DC-mBOT-Kb-Cmd)
    $_B.Write(Cmds,Mode,%DC-mBOT-Mode-Cmd)
    $_B.Write(Cmds,Topic,%DC-mBOT-Topic-Cmd)
    $_B.Write(Cmds,Invite,%DC-mBOT-Invite-Cmd)
    $_B.Write(Cmds,Slap,%DC-mBOT-Slap-Cmd)
    $_B.Write(Cmds,Say,%DC-mBOT-Say-Cmd)
    $_B.Write(Cmds,Act,%DC-mBOT-Act-Cmd)
    $_B.Write(Cmds,Fsh,%DC-mBOT-Fsh-Cmd)
    $_B.Write(Cmds,BanType,%DC-mBOT-BanType-Cmd)
    $_B.Write(Cmds,Pro,%DC-mBOT-Pro-Cmd)
    $_B.Write(Cmds,Nick,%DC-mBOT-Nick-Cmd)
    $_B.Write(Cmds,Identify,%DC-mBOT-Identify-Cmd)
    $_B.Write(Cmds,Join,%DC-mBOT-Join-Cmd)
    $_B.Write(Cmds,Part,%DC-mBOT-Part-Cmd)
    $_B.Write(Cmds,BotOff,%DC-mBOT-BotOff-Cmd)
    $_B.Write(Cmds,Quit,%DC-mBOT-Quit-Cmd)
    $_B.Write(Cmds,Help,%DC-mBOT-Help-Cmd)
    $_B.Write(Cmds,Admaster,%DC-mBOT-Admaster-Cmd)
  }

  if ($dialog(DC.BackUp)) { did -ve DC.BackUp 16 }
  if ($_B.Reads(Settings,Pro) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($dialog(DC.BackUp)) { did -ra DC.BackUp 13 Saving Protections Settings... }

    ; mBOT Protections
    $_B.Write(Pro,Shit-Kick-Msg,%Shit-Kick-Msg)
    $_B.Write(Pro,Shit-Kick-Ban-Msg,%Shit-Kick-Ban-Msg)
    $_B.Write(Pro,Shit-Offens,%Shit-Offens)

    $_B.Write(Pro,Badwords,%Badwords)
    $_B.Write(Pro,Badwords-Act,%Badwords-Act)
    $_B.Write(Pro,Badwords.Time,%Badwords-BanTime)
    $_B.Write(Pro,Badwords.Msg,%Badwords.Msg)
    if ($exists($DC.Dir(Doc\Badwords.txt))) { .copy -o $DC.Dir(Doc\Badwords.txt) $iif(%BU.Dir == $null, $DC.Dir(BackUp\Badwords.txt), $DC.Dir(BackUp\ $+ %BU.Dir $+ \Badwords.txt)) }

    $_B.Write(Pro,BadNicks,%BadNicks)
    $_B.Write(Pro,BadNicks-Act,%BadNicks-Act)
    $_B.Write(Pro,BadNicks-Time,%BadNicks-BanTime)
    $_B.Write(Pro,BadNicks.Msg,%BadNicks.Msg)
    if ($exists($DC.Dir(Doc\BadNicks.txt))) { .copy -o $DC.Dir(Doc\BadNicks.txt) $iif(%BU.Dir == $null, $DC.Dir(BackUp\BadNicks.txt), $DC.Dir(BackUp\ $+ %BU.Dir $+ \BadNicks.txt)) }

    $_B.Write(Pro,Adv,%Adv)
    $_B.Write(Pro,Adv-Serv,%Adv-Serv)
    $_B.Write(Pro,Adv-Chan,%Adv-Chan)
    $_B.Write(Pro,Adv-Site,%Adv-Site)
    $_B.Write(Pro,Adv-Act,%Adv-Act)
    $_B.Write(Pro,Adv-Time,%Adv-BanTime)
    $_B.Write(Pro,Adv.Msg,%Adv.Msg)

    $_B.Write(Pro,Repeat,%Repeat)
    $_B.Write(Pro,Repeat-Line,%Repeat-Lines)
    $_B.Write(Pro,Repeat-In,%Repeat-In)
    $_B.Write(Pro,Repeat-Act,%Repeat-Act)
    $_B.Write(Pro,Repeat-Time,%Repeat-BanTime)
    $_B.Write(Pro,Repeat.Msg,%Repeat.Msg)
    $_B.Write(Pro,Repeat.AutoModes,%Repeat.AutoModes)
    $_B.Write(Pro,Repeat-AM.Count,%Repeat-AM.Count)
    $_B.Write(Pro,Repeat-AM.In,%Repeat-AM.In)
    $_B.Write(Pro,Repeat-AM.Modes,%Repeat-AM.Modes)
    $_B.Write(Pro,Repeat-AM.For,%Repeat-AM.For)

    $_B.Write(Pro,BigMsg,%BigMsg)
    $_B.Write(Pro,BigMsg-Act,%BigMsg-Act)
    $_B.Write(Pro,BigMsg-Max,%BigMsg-Max)
    $_B.Write(Pro,BigMsg-Time,%BigMsg-BanTime)
    $_B.Write(Pro,BigMsg.Msg,%BigMsg.Msg)

    if ($dialog(DC.BackUp) != $null) { did -ve DC.BackUp 17 }

    $_B.Write(Pro,JoinPart,%JoinPart)
    $_B.Write(Pro,JoinPart-Act,%JoinPart-Act)
    $_B.Write(Pro,JoinPart-In,%JoinPart-In)
    $_B.Write(Pro,JoinPart-Time,%JoinPart-BanTime)
    $_B.Write(Pro,JoinPart.Msg,%JoinPart.Msg)
    $_B.Write(Pro,JoinPart.AutoModes,%JoinPart.AutoModes)
    $_B.Write(Pro,JoinPart-AM.Count,%JoinPart-AM.Count)
    $_B.Write(Pro,JoinPart-AM.In,%JoinPart-AM.In)
    $_B.Write(Pro,JoinPart-AM.Modes,%JoinPart-AM.Modes)
    $_B.Write(Pro,JoinPart-AM.For,%JoinPart-AM.For)

    $_B.Write(Pro,Flood,%Flood)
    $_B.Write(Pro,Flood-Line,%Flood-Lines)
    $_B.Write(Pro,Flood-In,%Flood-In)
    $_B.Write(Pro,Flood-Act,%Flood-Act)
    $_B.Write(Pro,Flood-Time,%Flood-BanTime)
    $_B.Write(Pro,Flood.Msg,%Flood.Msg)
    $_B.Write(Pro,Flood.AutoModes,%Flood.AutoModes)
    $_B.Write(Pro,Flood-AM.Count,%Flood-AM.Count)
    $_B.Write(Pro,Flood-AM.In,%Flood-AM.In)
    $_B.Write(Pro,Flood-AM.Modes,%Flood-AM.Modes)
    $_B.Write(Pro,Flood-AM.For,%Flood-AM.For)

    $_B.Write(Pro,JoinFlood,%JoinFlood)
    $_B.Write(Pro,JoinFlood-Max,%JoinFlood-Max)
    $_B.Write(Pro,JoinFlood-In,%JoinFlood-In)
    $_B.Write(Pro,JoinFlood-Act,%JoinFlood-Act)
    $_B.Write(Pro,JoinFlood-Time,%JoinFlood-BanTime)
    $_B.Write(Pro,JoinFlood.Msg,%JoinFlood.Msg)
    $_B.Write(Pro,JoinFlood.AutoModes,%JoinFlood.AutoModes)
    $_B.Write(Pro,JoinFlood-AM.Modes,%JoinFlood-AM.Modes)
    $_B.Write(Pro,JoinFlood-AM.For,%JoinFlood-AM.For)

    $_B.Write(Pro,NickFlood,%NickFlood)
    $_B.Write(Pro,NickFlood-Act,%NickFlood-Act)
    $_B.Write(Pro,NickFlood-Max,%NickFlood-Max)
    $_B.Write(Pro,NickFlood-Time,%NickFlood-BanTime)
    $_B.Write(Pro,NickFlood.Msg,%NickFlood.Msg)
    $_B.Write(Pro,NickFlood.AutoModes,%NickFlood.AutoModes)
    $_B.Write(Pro,NickFlood-AM.Modes,%NickFlood-AM.Modes)
    $_B.Write(Pro,NickFlood-AM.For,%NickFlood-AM.For)
    $_B.Write(Pro,Anti.ClonesX,%Anti.ClonesX)

    if ($dialog(DC.BackUp)) { did -ve DC.BackUp 18 }

    $_B.Write(Pro,FS,%FS)
    $_B.Write(Pro,FS-Mode-Auto,%FS-Mode-Auto)
    $_B.Write(Pro,FS-Msgg,%FS-Msgg)
    $_B.Write(Pro,FS-MsgMode,%FS-MsgMode)
    $_B.Write(Pro,FS-Bans,%FS-Bans)
    $_B.Write(Pro,FS-Time,%FS-Time)
    $_B.Write(Pro,FS-Set,%FS-Set)
    $_B.Write(Pro,FS-Mode,%FS-Mode)

    $_B.Write(Pro,Clones,%Clones)
    $_B.Write(Pro,Clones-Max,%Clones-Max)
    $_B.Write(Pro,Clones-Act,%Clones-Act)
    $_B.Write(Pro,Clones.Msg,%Clones.Msg)
    $_B.Write(Pro,Clones.AutoModes,%Clones.AutoModes)
    $_B.Write(Pro,Clones-AM.Count,%Clones-AM.Count)
    $_B.Write(Pro,Clones-AM.In,%Clones-AM.In)
    $_B.Write(Pro,Clones-AM.Modes,%Clones-AM.Modes)
    $_B.Write(Pro,Clones-AM.For,%Clones-AM.For)

    $_B.Write(Pro,Dont-Kb-Op,%Dont-Kb-Op)
    $_B.Write(Pro,Dont-Kb-Voice,%Dont-Kb-Voice)
    $_B.Write(Pro,Send-Notice-BNick,%Send-Notice-BNick)
    $_B.Write(Pro,NoOne-Ban,%NoOne-Ban)
    $_B.Write(Pro,NoOne-Deop,%NoOne-Deop)
  }
  if ($dialog(DC.BackUp)) { did -ve DC.BackUp 19 }

  if ($_B.Reads(Settings,Extra) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($dialog(DC.BackUp)) { did -ra DC.BackUp 13 Saving Extra Settings... }

    ; mBOT Extra Settings
    $_B.Write(Extra,Extra-Set,%Extra-Set)
    $_B.Write(Extra,Auto-Voice,%Auto-Voice)
    $_B.Write(Extra,Auto-Voice-Model,%Auto-Voice-Model)
    $_B.Write(Extra,Auto-Voice.Words,%Auto-Voice.Words)
    $_B.Write(Extra,Auto-Voice.WMins,%Auto-Voice.WMins)
    $_B.Write(Extra,Auto-Voice.Letters,%Auto-Voice.Letters)
    $_B.Write(Extra,Auto-Voice.LMins,%Auto-Voice.LMins)
    $_B.Write(Extra,Auto-Devoice,%Auto-Devoice)
    $_B.Write(Extra,Auto-Devoice.Idle,%Auto-Devoice.Idle)
    $_B.Write(Extra,Auto-Devoice-Check,%Auto-Devoice-Check)
    $_B.Write(Extra,Weather-Cmd,%Weather-Cmd)
    $_B.Write(Extra,Top10,%Top10)
    $_B.Write(Extra,IP-Loc-Cmd,%IP-Loc-Cmd)
    $_B.Write(Extra,DC-mBOT-Talking-Cmd,%DC-mBOT-Talking-Cmd)
    $_B.Write(Extra,Seen,$readini(mBOT\xSeen.ini,settings,status))
    $_B.Write(Extra,Ping,%Pingg)
  }
  if ($dialog(DC.BackUp)) { did -ra DC.BackUp 13 Copying Other Files... }

  $_B.Write(Toolbar,Status,%DC-Toolbar)
  if ($_B.Reads(Settings,Seen) == 1) || ($_B.Reads(Settings,Mode) == All) {
    Top10.SaveStats
    if ($exists($DC.Dir(mBOT\ChanStats.dat))) { .copy -o $DC.Dir(mBOT\ChanStats.dat) $iif(%BU.Dir == $null, $DC.Dir(BackUp\ChanStats.dat), $DC.Dir(BackUp\ $+ %BU.Dir $+ \ChanStats.dat)) }
  }
  if ($_B.Reads(Settings,Seen) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($hget(xSeen)) { xseen.save }
    if ($exists($DC.Dir(mBOT\xSeen.bak))) { .copy -o $DC.Dir(mBOT\xSeen.bak) $iif(%BU.Dir == $null, $DC.Dir(BackUp\xSeen.bak), $DC.Dir(BackUp\ $+ %BU.Dir $+ \xSeen.bak)) }
    if ($exists($DC.Dir(mBOT\xSeen.dat))) { .copy -o $DC.Dir(mBOT\xSeen.dat) $iif(%BU.Dir == $null, $DC.Dir(BackUp\xSeen.dat), $DC.Dir(BackUp\ $+ %BU.Dir $+ \xSeen.dat)) }
    if ($exists($DC.Dir(mBOT\xSeen.ini))) { .copy -o $DC.Dir(mBOT\xSeen.ini) $iif(%BU.Dir == $null, $DC.Dir(BackUp\xSeen.ini), $DC.Dir(BackUp\ $+ %BU.Dir $+ \xSeen.ini)) }
    if ($exists($DC.Dir(mBOT\xSeenmsgs.dat))) { .copy -o $DC.Dir(mBOT\xSeenmsgs.dat) $iif(%BU.Dir == $null, $DC.Dir(BackUp\xSeenmsgs.dat), $DC.Dir(BackUp\ $+ %BU.Dir $+ \xSeenmsgs.dat)) }
  }
  if ($_B.Reads(Settings,Extra) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($exists($DC.Dir(mBOT\NV.ini))) { .copy -o $DC.Dir(mBOT\NV.ini) $iif(%BU.Dir == $null, $DC.Dir(BackUp\NV.ini), $DC.Dir(BackUp\ $+ %BU.Dir $+ \NV.ini)) }
  }
  if ($_B.Reads(Settings,Main) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($exists($DC.Dir(mBOT\Masters.ini))) { .copy -o $DC.Dir(mBOT\Masters.ini) $iif(%BU.Dir == $null, $DC.Dir(BackUp\Masters.ini), $DC.Dir(BackUp\ $+ %BU.Dir $+ \Masters.ini)) }
  }
  if ($_B.Reads(Settings,Connections) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($exists($DC.Dir(mBOT\Connections.ini))) { .copy -o $DC.Dir(mBOT\Connections.ini) $iif(%BU.Dir == $null, $DC.Dir(BackUp\Connections.ini), $DC.Dir(BackUp\ $+ %BU.Dir $+ \Connections.ini)) }
  }
  if ($_B.Reads(Settings,IRCop) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($exists($DC.Dir(mBOT\Admin.ini))) { .copy -o $DC.Dir(mBOT\Admin.ini) $iif(%BU.Dir == $null, $DC.Dir(BackUp\Admin.ini), $DC.Dir(BackUp\ $+ %BU.Dir $+ \Admin.ini)) }
  }
  if ($_B.Reads(Settings,Member) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($exists($DC.Dir(mBOT\User.mrc))) { .copy -o $DC.Dir(mBOT\User.mrc) $iif(%BU.Dir == $null, $DC.Dir(BackUp\User.mrc), $DC.Dir(BackUp\ $+ %BU.Dir $+ \User.mrc)) }
  }
  if ($_B.Reads(Settings,mIRC) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($exists($DC.Dir(mIRC.ini))) { .copy -o $DC.Dir(mIRC.ini) $iif(%BU.Dir == $null, $DC.Dir(BackUp\mIRC.ini), $DC.Dir(BackUp\ $+ %BU.Dir $+ \mIRC.ini)) }
  }
  if ($_B.Reads(Settings,Talk) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($exists($DC.Dir(mBOT\Talker.ini))) { .copy -o $DC.Dir(mBOT\Talker.ini) $iif(%BU.Dir == $null, $DC.Dir(BackUp\Talker.ini), $DC.Dir(BackUp\ $+ %BU.Dir $+ \Talker.ini)) }
  }
  if ($_B.Reads(Settings,SB) == 1) || ($_B.Reads(Settings,Mode) == All) {
    if ($exists($DC.Dir(mBOT\Statusbar\SB.ini))) { .copy -o $DC.Dir(mBOT\Statusbar\SB.ini) $iif(%BU.Dir == $null, $DC.Dir(BackUp\SB.ini), $DC.Dir(BackUp\ $+ %BU.Dir $+ \SB.ini)) }
  }
  if ($dialog(DC.BackUp)) { did -hb DC.BackUp 7,8,9,10,11,22,23,26 | did -ve DC.BackUp 21 }
  if ($dialog(DC.BackUp)) { did -ve DC.BackUp 20 }
  if ($dialog(DC.BackUp)) { did -ra DC.BackUp 13 BackUp Files Was Created! }

  if ($server) && (%Daily.BU == ON) { .timer.poof 1 1 /scon -at1 amsg Daily Backup files successfully saved! }
  unset %Daily.BU
  if (%BU.Today != 1) { BU.Date.Rec $replace($date,$chr(32),$chr(45),$chr(46),$chr(45),$chr(95),$chr(45),$chr(47),$chr(45),$chr(92),$chr(45)) | unset %BU.Today }
}

alias -l R.BackUp {
  ; Restoring Daily Backup
  Backup.Save
  if ($dialog(DC.BackUp)) { did -ve DC.BackUp 15 }

  if ($did(DC.BackUp,3,1).cstate == 1) {
    ; Restoring mBOT Settings
    set %Enable.DC.mBOT $iif($_B.Read(mBOT,Bot) != $null, $_B.Read(mBOT,Bot)) | $iif(%Enable.DC.mBOT == ON, .enable #DC-mBOT, .disable #DC-mBOT)
    set %Owner-DC.mBOT $iif($_B.Read(mBOT,Owner) != $null, $_B.Read(mBOT,Owner))
    set %Co.Owner-DC.mBOT $iif($_B.Read(mBOT,Co-Owner) != $null, $_B.Read(mBOT,Co-Owner))
    set %DC-mBOT-Custom-Trigger $iif($_B.Read(mBOT,Triggers) != $null, $_B.Read(mBOT,Triggers))
    set %Trigger $iif($_B.Read(mBOT,Trigger) != $null, $_B.Read(mBOT,Trigger))
    set %DC-mBOT-UIgnore.Times $iif($_B.Read(mBOT,Ignore-T) != $null, $_B.Read(mBOT,Ignore-T))
    set %DC-mBOT-UIgnore.Ban $iif($_B.Read(mBOT,Ignore-B) != $null, $_B.Read(mBOT,Ignore-B))
    set %Bot-BanTypes $iif($_B.Read(mBOT,Btype) != $null, $_B.Read(mBOT,Btype))
    set %Notice.Cmds $iif($_B.Read(mBOT,Notice.Cmds) != $null, $_B.Read(mBOT,Notice.Cmds))
    set %Notice.Pass $iif($_B.Read(mBOT,Notice.Pass) != $null, $_B.Read(mBOT,Notice.Pass))

    ; Restoring mBOT Commands
    set %DC-mBOT-Op-Cmd $iif($_B.Read(Cmds,Op) != $null, $_B.Read(Cmds,Op))
    set %DC-mBOT-Voice-Cmd $iif($_B.Read(Cmds,Voice) != $null, $_B.Read(Cmds,Voice))
    set %DC-mBOT-Ban-Cmd $iif($_B.Read(Cmds,Ban) != $null, $_B.Read(Cmds,Ban))
    set %DC-mBOT-DeOp-Cmd $iif($_B.Read(Cmds,DeOp) != $null, $_B.Read(Cmds,DeOp))
    set %DC-mBOT-DeVoice-Cmd $iif($_B.Read(Cmds,DeVoice) != $null, $_B.Read(Cmds,DeVoice))
    set %DC-mBOT-UnBan-Cmd $iif($_B.Read(Cmds,UnBan) != $null, $_B.Read(Cmds,UnBan))
    set %DC-mBOT-Kick-Cmd $iif($_B.Read(Cmds,Kick) != $null, $_B.Read(Cmds,Kick))
    set %DC-mBOT-Kb-Cmd $iif($_B.Read(Cmds,Kb) != $null, $_B.Read(Cmds,Kb))
    set %DC-mBOT-Mode-Cmd $iif($_B.Read(Cmds,Mode) != $null, $_B.Read(Cmds,Mode))
    set %DC-mBOT-Topic-Cmd $iif($_B.Read(Cmds,Topic) != $null, $_B.Read(Cmds,Topic))
    set %DC-mBOT-Invite-Cmd $iif($_B.Read(Cmds,Invite) != $null, $_B.Read(Cmds,Invite))
    set %DC-mBOT-Slap-Cmd $iif($_B.Read(Cmds,Slap) != $null, $_B.Read(Cmds,Slap))
    set %DC-mBOT-Say-Cmd $iif($_B.Read(Cmds,Say) != $null, $_B.Read(Cmds,Say))
    set %DC-mBOT-Act-Cmd $iif($_B.Read(Cmds,Act) != $null, $_B.Read(Cmds,Act))
    set %DC-mBOT-Fsh-Cmd $iif($_B.Read(Cmds,Fsh) != $null, $_B.Read(Cmds,Fsh))
    set %DC-mBOT-BanType-Cmd $iif($_B.Read(Cmds,BanType) != $null, $_B.Read(Cmds,BanType))
    set %DC-mBOT-Pro-Cmd $iif($_B.Read(Cmds,Pro) != $null, $_B.Read(Cmds,Pro)) | $iif(%DC-mBOT-Pro-Cmd == ON, .enable #Bot-Pro, .disable #Bot-Pro)
    set %DC-mBOT-Nick-Cmd $iif($_B.Read(Cmds,Nick) != $null, $_B.Read(Cmds,Nick))
    set %DC-mBOT-Identify-Cmd $iif($_B.Read(Cmds,Identify) != $null, $_B.Read(Cmds,Identify))
    set %DC-mBOT-Join-Cmd $iif($_B.Read(Cmds,Join) != $null, $_B.Read(Cmds,Join))
    set %DC-mBOT-Part-Cmd $iif($_B.Read(Cmds,Part) != $null, $_B.Read(Cmds,Part))
    set %DC-mBOT-BotOff-Cmd $iif($_B.Read(Cmds,BotOff) != $null, $_B.Read(Cmds,BotOff))
    set %DC-mBOT-Quit-Cmd $iif($_B.Read(Cmds,Quit) != $null, $_B.Read(Cmds,Quit))
    set %DC-mBOT-Help-Cmd $iif($_B.Read(Cmds,Help) != $null, $_B.Read(Cmds,Help))
    set %DC-mBOT-Admaster-Cmd $iif($_B.Read(Cmds,Admaster) != $null, $_B.Read(Cmds,Admaster))
  }
  if ($dialog(DC.BackUp)) { did -ve DC.BackUp 16 }
  if ($dialog(DC.BackUp)) { did -ra DC.BackUp 13 Restoring Protections Settings... }

  if ($did(DC.BackUp,3,2).cstate == 1) {
    ; Restoring mBOT Protections
    set %Badwords $iif($_B.Read(Pro,Badwords) != $null, $_B.Read(Pro,Badwords))
    set %Badwords-Act $iif($_B.Read(Pro,Badwords-Act) != $null, $_B.Read(Pro,Badwords-Act))
    set %Badwords-BanTime $iif($_B.Read(Pro,Badwords.Time) != $null, $_B.Read(Pro,Badwords.Time))
    set %Badwords.Msg $iif($_B.Read(Pro,Badwords.Msg) != $null, $_B.Read(Pro,Badwords.Msg))
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \Badwords.txt))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \Badwords.txt) $DC.Dir(Doc\Badwords.txt) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\Badwords.txt))) { .copy -o $DC.Dir(BackUp\Badwords.txt) $DC.Dir(Doc\Badwords.txt) }

    set %BadNicks $iif($_B.Read(Pro,BadNicks) != $null, $_B.Read(Pro,BadNicks))
    set %BadNicks-Act $iif($_B.Read(Pro,BadNicks-Act) != $null, $_B.Read(Pro,BadNicks-Act))
    set %BadNicks-BanTime $iif($_B.Read(Pro,BadNicks-Time) != $null, $_B.Read(Pro,BadNicks-Time))
    set %BadNicks.Msg $iif($_B.Read(Pro,BadNicks.Msg) != $null, $_B.Read(Pro,BadNicks.Msg))
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \Badnicks.txt))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \Badnicks.txt) $DC.Dir(Doc\Badnicks.txt) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\Badnicks.txt))) { .copy -o $DC.Dir(BackUp\Badnicks.txt) $DC.Dir(Doc\Badnicks.txt) }

    set %Adv $iif($_B.Read(Pro,Adv) != $null, $_B.Read(Pro,Adv))
    set %Adv-Serv $iif($_B.Read(Pro,Adv-Serv) != $null, $_B.Read(Pro,Adv-Serv))
    set %Adv-Chan $iif($_B.Read(Pro,Adv-Chan) != $null, $_B.Read(Pro,Adv-Chan))
    set %Adv-Site $iif($_B.Read(Pro,Adv-Site) != $null, $_B.Read(Pro,Adv-Site))
    set %Adv-Act $iif($_B.Read(Pro,Adv-Act) != $null, $_B.Read(Pro,Adv-Act))
    set %Adv-BanTime $iif($_B.Read(Pro,Adv-Time) != $null, $_B.Read(Pro,Adv-Time))
    set %Adv.Msg $iif($_B.Read(Pro,Adv.Msg) != $null, $_B.Read(Pro,Adv.Msg))

    set %Repeat $iif($_B.Read(Pro,Repeat) != $null, $_B.Read(Pro,Repeat))
    set %Repeat-Lines $iif($_B.Read(Pro,Repeat-Line) != $null, $_B.Read(Pro,Repeat-Line))
    set %Repeat-In $iif($_B.Read(Pro,Repeat-In) != $null, $_B.Read(Pro,Repeat-In))
    set %Repeat-Act $iif($_B.Read(Pro,Repeat-Act) != $null, $_B.Read(Pro,Repeat-Act))
    set %Repeat-BanTime $iif($_B.Read(Pro,Repeat-Time) != $null, $_B.Read(Pro,Repeat-Time))
    set %Repeat.Msg $iif($_B.Read(Pro,Repeat.Msg) != $null, $_B.Read(Pro,Repeat.Msg))
    set %Repeat.AutoModes $iif($_B.Read(Pro,Repeat.AutoModes) != $null, $_B.Read(Pro,Repeat.AutoModes))
    set %Repeat-AM.Count $iif($_B.Read(Pro,Repeat-AM.Count) != $null, $_B.Read(Pro,Repeat-AM.Count))
    set %Repeat-AM.In $iif($_B.Read(Pro,Repeat-AM.In) != $null, $_B.Read(Pro,Repeat-AM.In))
    set %Repeat-AM.Modes $iif($_B.Read(Pro,Repeat-AM.Modes) != $null, $_B.Read(Pro,Repeat-AM.Modes))
    set %Repeat-AM.For $iif($_B.Read(Pro,Repeat-AM.For) != $null, $_B.Read(Pro,Repeat-AM.For))

    set %BigMsg $iif($_B.Read(Pro,BigMsg) != $null, $_B.Read(Pro,BigMsg))
    set %BigMsg-Act $iif($_B.Read(Pro,BigMsg-Act) != $null, $_B.Read(Pro,BigMsg-Act))
    set %BigMsg-Max $iif($_B.Read(Pro,BigMsg-Max) != $null, $_B.Read(Pro,BigMsg-Max))
    set %BigMsg-BanTime $iif($_B.Read(Pro,BigMsg-Time) != $null, $_B.Read(Pro,BigMsg-Time))
    set %BigMsg.Msg $iif($_B.Read(Pro,BigMsg.Msg) != $null, $_B.Read(Pro,BigMsg.Msg))

    if ($dialog(DC.BackUp)) { did -ve DC.BackUp 17 }

    set %JoinPart $iif($_B.Read(Pro,JoinPart) != $null, $_B.Read(Pro,JoinPart))
    set %JoinPart-Act $iif($_B.Read(Pro,JoinPart-Act) != $null, $_B.Read(Pro,JoinPart-Act))
    set %JoinPart-In $iif($_B.Read(Pro,JoinPart-In) != $null, $_B.Read(Pro,JoinPart-In))
    set %JoinPart-BanTime $iif($_B.Read(Pro,JoinPart-Time) != $null, $_B.Read(Pro,JoinPart-Time))
    set %JoinPart.Msg $iif($_B.Read(Pro,JoinPart.Msg) != $null, $_B.Read(Pro,JoinPart.Msg))
    set %JoinPart.AutoModes $iif($_B.Read(Pro,JoinPart.AutoModes) != $null, $_B.Read(Pro,JoinPart.AutoModes))
    set %JoinPart-AM.Count $iif($_B.Read(Pro,JoinPart-AM.Count) != $null, $_B.Read(Pro,JoinPart-AM.Count))
    set %JoinPart-AM.In $iif($_B.Read(Pro,JoinPart-AM.In) != $null, $_B.Read(Pro,JoinPart-AM.In))
    set %JoinPart-AM.Modes $iif($_B.Read(Pro,JoinPart-AM.Modes) != $null, $_B.Read(Pro,JoinPart-AM.Modes))
    set %JoinPart-AM.For $iif($_B.Read(Pro,JoinPart-AM.For) != $null, $_B.Read(Pro,JoinPart-AM.For))

    set %Flood $iif($_B.Read(Pro,Flood) != $null, $_B.Read(Pro,Flood))
    set %Flood-Lines $iif($_B.Read(Pro,Flood-Line) != $null, $_B.Read(Pro,Flood-Line))
    set %Flood-In $iif($_B.Read(Pro,Flood-In) != $null, $_B.Read(Pro,Flood-In))
    set %Flood-Act $iif($_B.Read(Pro,Flood-Act) != $null, $_B.Read(Pro,Flood-Act))
    set %Flood-BanTime $iif($_B.Read(Pro,Flood-Time) != $null, $_B.Read(Pro,Flood-Time))
    set %Flood.Msg $iif($_B.Read(Pro,Flood.Msg) != $null, $_B.Read(Pro,Flood.Msg))
    set %Flood.AutoModes $iif($_B.Read(Pro,Flood.AutoModes) != $null, $_B.Read(Pro,Flood.AutoModes))
    set %Flood-AM.Count $iif($_B.Read(Pro,Flood-AM.Count) != $null, $_B.Read(Pro,Flood-AM.Count))
    set %Flood-AM.In $iif($_B.Read(Pro,Flood-AM.In) != $null, $_B.Read(Pro,Flood-AM.In))
    set %Flood-AM.Modes $iif($_B.Read(Pro,Flood-AM.Modes) != $null, $_B.Read(Pro,Flood-AM.Modes))
    set %Flood-AM.For $iif($_B.Read(Pro,Flood-AM.For) != $null, $_B.Read(Pro,Flood-AM.For))

    set %JoinFlood $iif($_B.Read(Pro,JoinFlood) != $null, $_B.Read(Pro,Pro,JoinFlood))
    set %JoinFlood-Max $iif($_B.Read(Pro,JoinFlood-Max) != $null, $_B.Read(Pro,JoinFlood-Max))
    set %JoinFlood-In $iif($_B.Read(Pro,JoinFlood-In) != $null, $_B.Read(Pro,JoinFlood-In))
    set %JoinFlood-Act $iif($_B.Read(Pro,JoinFlood-Act) != $null, $_B.Read(Pro,JoinFlood-Act))
    set %JoinFlood-BanTime $iif($_B.Read(Pro,JoinFlood-Time) != $null, $_B.Read(Pro,JoinFlood-Time))
    set %JoinFlood.Msg $iif($_B.Read(Pro,JoinFlood.Msg) != $null, $_B.Read(Pro,JoinFlood.Msg))
    set %JoinFlood.AutoModes $iif($_B.Read(Pro,JoinFlood.AutoModes) != $null, $_B.Read(Pro,JoinFlood.AutoModes))
    set %JoinFlood-AM.Modes $iif($_B.Read(Pro,JoinFlood-AM.Modes) != $null, $_B.Read(Pro,JoinFlood-AM.Modes))
    set %JoinFlood-AM.For $iif($_B.Read(Pro,JoinFlood-AM.For) != $null, $_B.Read(Pro,JoinFlood-AM.For))

    set %NickFlood $iif($_B.Read(Pro,NickFlood) != $null, $_B.Read(Pro,NickFlood))
    set %NickFlood-Act $iif($_B.Read(Pro,NickFlood-Act) != $null, $_B.Read(Pro,NickFlood-Act))
    set %NickFlood-Max $iif($_B.Read(Pro,NickFlood-Max) != $null, $_B.Read(Pro,NickFlood-Max))
    set %NickFlood-BanTime $iif($_B.Read(Pro,NickFlood-Time) != $null, $_B.Read(Pro,NickFlood-Time))
    set %NickFlood.Msg $iif($_B.Read(Pro,NickFlood.Msg) != $null, $_B.Read(Pro,NickFlood.Msg))
    set %NickFlood.AutoModes $iif($_B.Read(Pro,NickFlood.AutoModes) != $null, $_B.Read(Pro,NickFlood.AutoModes))
    set %NickFlood-AM.Modes $iif($_B.Read(Pro,NickFlood-AM.Modes) != $null, $_B.Read(Pro,NickFlood-AM.Modes))
    set %NickFlood-AM.For $iif($_B.Read(Pro,NickFlood-AM.For) != $null, $_B.Read(Pro,NickFlood-AM.For))
    set %Anti.ClonesX $iif($_B.Read(Pro,Anti.ClonesX) != $null, $_B.Read(Pro,Anti.ClonesX))

    if ($dialog(DC.BackUp)) { did -ve DC.BackUp 18 }

    set %FS $iif($_B.Read(Pro,FS) != $null, $_B.Read(Pro,FS)) | $iif(%FS == ON, .enable #Flood.St, .disable #Flood.St)
    set %FS-Mode-Auto $iif($_B.Read(Pro,FS-Mode-Auto) != $null, $_B.Read(Pro,FS-Mode-Auto))
    set %FS-Msgg $iif($_B.Read(Pro,FS-Msgg) != $null, $_B.Read(Pro,FS-Msgg))
    set %FS-MsgMode $iif($_B.Read(Pro,FS-MsgMode) != $null, $_B.Read(Pro,FS-MsgMode))
    set %FS-Bans $iif($_B.Read(Pro,FS-Bans) != $null, $_B.Read(Pro,FS-Bans))
    set %FS-Time $iif($_B.Read(Pro,FS-Time) != $null, $_B.Read(Pro,FS-Time))
    set %FS-Set $iif($_B.Read(Pro,FS-Set) != $null, $_B.Read(Pro,FS-Set))
    set %FS-Mode $iif($_B.Read(Pro,FS-Mode) != $null, $_B.Read(Pro,FS-Mode))

    set %Clones $iif($_B.Read(Pro,Clones) != $null, $_B.Read(Pro,Clones))
    set %Clones-Max $iif($_B.Read(Pro,Clones-Max) != $null, $_B.Read(Pro,Clones-Max))
    set %Clones-Act $iif($_B.Read(Pro,Clones-Act) != $null, $_B.Read(Pro,Clones-Act))
    set %Clones.Msg $iif($_B.Read(Pro,Clones.Msg) != $null, $_B.Read(Pro,Clones.Msg))
    set %Clones.AutoModes $iif($_B.Read(Pro,Clones.AutoModes) != $null, $_B.Read(Pro,Clones.AutoModes))
    set %Clones-AM.Count $iif($_B.Read(Pro,Clones-AM.Count) != $null, $_B.Read(Pro,Clones-AM.Count))
    set %Clones-AM.In $iif($_B.Read(Pro,Clones-AM.In) != $null, $_B.Read(Pro,Clones-AM.In))
    set %Clones-AM.Modes $iif($_B.Read(Pro,Clones-AM.Modes) != $null, $_B.Read(Pro,Clones-AM.Modes))
    set %Clones-AM.For $iif($_B.Read(Pro,Clones-AM.For) != $null, $_B.Read(Pro,Clones-AM.For))

    set %Dont-Kb-Op $iif($_B.Read(Pro,Dont-Kb-Op) != $null, $_B.Read(Pro,Dont-Kb-Op))
    set %Dont-Kb-Voice $iif($_B.Read(Pro,Dont-Kb-Voice) != $null, $_B.Read(Pro,Dont-Kb-Voice))
    set %Send-Notice-BNick $iif($_B.Read(Pro,Send-Notice-BNick) != $null, $_B.Read(Pro,Send-Notice-BNick))
    set %NoOne-Ban $iif($_B.Read(Pro,NoOne-Ban) != $null, $_B.Read(Pro,NoOne-Ban))
    set %NoOne-Deop $iif($_B.Read(Pro,NoOne-Deop) != $null, $_B.Read(Pro,NoOne-Deop))
  }

  if ($dialog(DC.BackUp)) { did -ve DC.BackUp 19 }
  if ($dialog(DC.BackUp)) { did -ra DC.BackUp 13 Restoring Extra Settings... }

  if ($did(DC.BackUp,3,4).cstate == 1) {
    ; Restoring mBOT Extra Settings
    set %Extra-Set $iif($_B.Read(Extra,Extra-Set) != $null, $_B.Read(Extra,Extra-Set))
    set %Auto-Voice $iif($_B.Read(Extra,Auto-Voice) != $null, $_B.Read(Extra,Auto-Voice))
    set %Auto-Voice-Model $iif($_B.Read(Extra,Auto-Voice-Model) != $null, $_B.Read(Extra,Auto-Voice-Model))
    set %Auto-Voice.Words $iif($_B.Read(Extra,Auto-Voice.Words) != $null, $_B.Read(Extra,Auto-Voice.Words))
    set %Auto-Voice.WMins $iif($_B.Read(Extra,Auto-Voice.WMins) != $null, $_B.Read(Extra,Auto-Voice.WMins))
    set %Auto-Voice.Letters $iif($_B.Read(Extra,Auto-Voice.Letters) != $null, $_B.Read(Extra,Auto-Voice.Letters))
    set %Auto-Voice.LMins $iif($_B.Read(Extra,Auto-Voice.LMins) != $null, $_B.Read(Extra,Auto-Voice.LMins))
    set %Auto-Devoice $iif($_B.Read(Extra,Auto-Devoice) != $null, $_B.Read(Extra,Auto-Devoice))
    set %Auto-Devoice.Idle $iif($_B.Read(Extra,Auto-Devoice.Idle) != $null, $_B.Read(Extra,Auto-Devoice.Idle))
    set %Auto-Devoice-Check $iif($_B.Read(Extra,Auto-Devoice-Check) != $null, $_B.Read(Extra,Auto-Devoice-Check))
    set %Weather-Cmd $iif($_B.Read(Extra,Weather-Cmd) != $null, $_B.Read(Extra,Weather-Cmd))
    set %Top10 $iif($_B.Read(Extra,Top10) != $null, $_B.Read(Extra,Top10))
    set %IP-Loc-Cmd $iif($_B.Read(Extra,IP-Loc-Cmd) != $null, $_B.Read(Extra,IP-Loc-Cmd))
    set %DC-mBOT-Talking-Cmd $iif($_B.Read(Extra,DC-mBOT-Talking-Cmd) != $null, $_B.Read(Extra,DC-mBOT-Talking-Cmd))
    set %Pingg $iif($_B.Read(Extra,Ping) != $null, $_B.Read(Extra,Ping)) | $iif(%Pingg == ON, .enable #Pinger, .disable #Pinger)
  }

  if ($dialog(DC.BackUp)) { did -ra DC.BackUp 13 Restoring Other Files... }

  set %DC-Toolbar $iif($_B.Read(Toolbar,Status) != $null, $_B.Read(Toolbar,Status))

  if ($did(DC.BackUp,3,8).cstate == 1) {
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \ChanStats.dat))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \ChanStats.dat) $DC.Dir(mBOT\ChanStats.dat) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\ChanStats.dat))) { .copy -o $DC.Dir(BackUp\ChanStats.dat) $DC.Dir(mBOT\ChanStats.dat) }
  }

  if ($did(DC.BackUp,3,5).cstate == 1) {
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \xSeen.bak))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \xSeen.bak) $DC.Dir(mBOT\xSeen.bak) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\xSeen.bak))) { .copy -o $DC.Dir(BackUp\xSeen.bak) $DC.Dir(mBOT\xSeen.bak) }

    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \xSeen.dat))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \xSeen.dat) $DC.Dir(mBOT\xSeen.dat) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\xSeen.dat))) { .copy -o $DC.Dir(BackUp\xSeen.dat) $DC.Dir(mBOT\xSeen.dat) }

    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \xSeen.ini))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \xSeen.ini) $DC.Dir(mBOT\xSeen.ini) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\xSeen.ini))) { .copy -o $DC.Dir(BackUp\xSeen.ini) $DC.Dir(mBOT\xSeen.ini) }

    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \xSeenmsgs.dat))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \xSeenmsgs.dat) $DC.Dir(mBOT\xSeenmsgs.dat) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\xSeenmsgs.dat))) { .copy -o $DC.Dir(BackUp\xSeenmsgs.dat) $DC.Dir(mBOT\xSeenmsgs.dat) }

  }
  if ($did(DC.BackUp,3,1).cstate == 1) {
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \Masters.ini))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \Masters.ini) $DC.Dir(mBOT\Masters.ini) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\Masters.ini))) { .copy -o $DC.Dir(BackUp\Masters.ini) $DC.Dir(mBOT\Masters.ini) }
  }
  if ($did(DC.BackUp,3,7).cstate == 1) {
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \Connections.ini))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \Connections.ini) $DC.Dir(mBOT\Connections.ini) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\Connections.ini))) { .copy -o $DC.Dir(BackUp\Connections.ini) $DC.Dir(mBOT\Connections.ini) }
  }
  if ($did(DC.BackUp,3,4).cstate == 1) {
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \NV.ini))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \NV.ini) $DC.Dir(mBOT\NV.ini) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\NV.ini))) { .copy -o $DC.Dir(BackUp\NV.ini) $DC.Dir(mBOT\NV.ini) }
    .writeini $DC.Dir(mBOT\xSeen.ini) settings status $_B.Read(Extra,Seen)
  }
  if ($did(DC.BackUp,3,6).cstate == 1) {
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \Admin.ini))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \Admin.ini) $DC.Dir(mBOT\Admin.ini) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\Admin.ini))) { .copy -o $DC.Dir(BackUp\Admin.ini) $DC.Dir(mBOT\Admin.ini) }
  }
  if ($did(DC.BackUp,3,3).cstate == 1) {
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \User.mrc))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \User.mrc) $DC.Dir(mBOT\User.mrc) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\User.mrc))) { .copy -o $DC.Dir(BackUp\User.mrc) $DC.Dir(mBOT\User.mrc) }
  }
  if ($did(DC.BackUp,3,10).cstate == 1) {
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \mIRC.ini))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \mIRC.ini) $DC.Dir(mIRC.ini) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\mIRC.ini))) { .copy -o $DC.Dir(BackUp\mIRC.ini) $DC.Dir(mIRC.ini) }
  }
  if ($did(DC.BackUp,3,9).cstate == 1) {
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \Talker.ini))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \Talker.ini) $DC.Dir(mBOT\Talker.ini) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\Talker.ini))) { .copy -o $DC.Dir(BackUp\Talker.ini) $DC.Dir(mBOT\Talker.ini) }
  }
  if ($did(DC.BackUp,3,11).cstate == 1) {
    if (%BU.Res) && ($exists($DC.Dir(BackUp\ $+ %BU.Res $+ \SB.ini))) { .copy -o $DC.Dir(BackUp\ $+ %BU.Res $+ \SB.ini) $DC.Dir(mBOT\SB.ini) }
    elseif (!%BU.Res) && ($exists($DC.Dir(BackUp\SB.ini))) { .copy -o $DC.Dir(BackUp\SB.ini) $DC.Dir(mBOT\Statusbar\SB.ini) }
  }
  if ($did(DC.BackUp,3,3).cstate == 1) && ($did(DC.BackUp,3,3).cstate == 1) { .load -ru $DC.Dir(mBOT\User.mrc) }

  ReloadAfterRestore

  if ($dialog(DC.BackUp)) { did -hb DC.BackUp 7,8,9,10,11,22,23,26 | did -ve DC.BackUp 21 }
  if ($dialog(DC.BackUp)) { did -ve DC.BackUp 20 }
  if ($dialog(DC.BackUp)) { did -ra DC.BackUp 13 BackUp Files Was Restored! }
}
alias -l Backup.Save {
  if ($dialog(DC.BackUp)) {
    if ($did(DC.BackUp,24).state == 0) && ($did(DC.BackUp,25).state == 0) { .writeini $DC.Dir(mBOT\Backup.ini) Settings Mode All }
    if ($did(DC.BackUp,24).state == 1) { .writeini $DC.Dir(mBOT\Backup.ini) Settings Mode Custom }
    if ($did(DC.BackUp,25).state == 1) { .writeini $DC.Dir(mBOT\Backup.ini) Settings Mode All }
    .writeini $DC.Dir(mBOT\Backup.ini) Settings Main $did(DC.BackUp,3,1).cstate
    .writeini $DC.Dir(mBOT\Backup.ini) Settings Pro $did(DC.BackUp,3,2).cstate
    .writeini $DC.Dir(mBOT\Backup.ini) Settings Member $did(DC.BackUp,3,3).cstate
    .writeini $DC.Dir(mBOT\Backup.ini) Settings Extra $did(DC.BackUp,3,4).cstate
    .writeini $DC.Dir(mBOT\Backup.ini) Settings Seen $did(DC.BackUp,3,5).cstate
    .writeini $DC.Dir(mBOT\Backup.ini) Settings IRCop $did(DC.BackUp,3,6).cstate
    .writeini $DC.Dir(mBOT\Backup.ini) Settings Connections $did(DC.BackUp,3,7).cstate
    .writeini $DC.Dir(mBOT\Backup.ini) Settings Top $did(DC.BackUp,3,8).cstate
    .writeini $DC.Dir(mBOT\Backup.ini) Settings Talk $did(DC.BackUp,3,9).cstate
    .writeini $DC.Dir(mBOT\Backup.ini) Settings mIRC $did(DC.BackUp,3,10).cstate
    .writeini $DC.Dir(mBOT\Backup.ini) Settings SB $did(DC.BackUp,3,11).cstate
  }
}

alias -l ReloadAfterRestore {
  ;Top10.ClearStats
  ;Top10.LoadStats

  .hfree -w total*
  .hfree -w todaytotal*
  Top10.LoadStats

  ; xSeen reload
  .hfree -w xSeen*
  .hmake xSeen 100
  .hmake xSeen.msgs 10
  .hload xSeen $_seen.log
  .hload xSeen.msgs $_seenmsgs.log
  if (%Extra-Set == OFF) { .writeini $_seen.file settings status 0 }
}



; [Dialog]
dialog DC.BackUp {
  title "DC mBOT BackUp"
  size -1 -1 134 170
  option dbu
  icon $DC.Imgs(BackUp.ico)
  box "", 1, -45 150 204 62
  list 3, 8 33 66 77, size vsbar check
  radio "Custom", 24, 80 88 34 9
  radio "Recommended", 25, 80 101 45 9
  text "Choose those options you want making Backup/Restore for them. You can use the 'Recommended' to create a Backup or Restore for everything in script. Don't forget these settings will be used in 'Daily Backup' too.", 4, 9 115 120 35, center
  button "Cancel", 7, 18 157 30 10, cancel
  button "Start (3)", 8, 83 157 40 10
  button "&Create", 9, 73 157 55 10, hide disable
  button "&Restore", 10, 73 139 55 10, hide disable
  combo 26, 8 139 60 60, hide disable sort size drop
  button "<<", 11, 5 157 12 10, disable
  box "", 12, 25 55 82 13, hide disable
  text "", 13, 8 42 113 8, hide disable center
  icon 14, 28 60 9 6, $noqt($DC.Imgs(Loading.ico)), 0, hide disable noborder
  icon 15, 39 60 9 6, $noqt($DC.Imgs(Loading.ico)), 0, hide disable noborder
  icon 16, 50 60 9 6, $noqt($DC.Imgs(Loading.ico)), 0, hide disable noborder
  icon 17, 61 60 9 6, $noqt($DC.Imgs(Loading.ico)), 0, hide disable noborder
  icon 18, 72 60 9 6, $noqt($DC.Imgs(Loading.ico)), 0, hide disable noborder
  icon 19, 83 60 9 6, $noqt($DC.Imgs(Loading.ico)), 0, hide disable noborder
  icon 20, 94 60 9 6, $noqt($DC.Imgs(Loading.ico)), 0, hide disable noborder
  button "&Done", 21, 91 157 33 10, hide disable
  text "Would you like to replace them? Click Yes to Continue or Cancel to Abort!", 22, 8 71 113 16, hide disable center
  button "&Yes", 23, 91 157 33 10, hide disable
  list 2, -6 -1 147 30, size
  list 5, 4 4 25 25, size
  text "Backup and Restore", 6, 29 3 111 15
  text "Create/Restore backup for settings", 27, 30 17 110 10
}

on *:dialog:DC.BackUp:*:*:{
  if ($devent == close) { unset %BU.Dir | unset %BU.Res | unset %BU.Today | Backup.Save }
  if ($devent == init) {
    hOS EnableCloseBox $dialog(DC.BackUp).hwnd true
    MDX MarkDialog $dname
    MDX SetMircVersion $version
    MDX SetBorderStyle $dname 2,5 simple
    MDX SetControlMDX $dname 5 Toolbar flat nodivider wrap list arrows > $Bars
    MDX SetColor $dname 2,5,6,27 background $rgb(199,199,199)
    MDX SetColor $dname 2,5,6,27 textbg $rgb(199,199,199)
    MDX SetColor $dname 2,6 text $rgb(65,141,255)
    MDX SetColor $dname 27 text $rgb(0,0,0)
    MDX SetFont $dname 6 +a 25 700 Ringbearer
    MDX SetFont $dname 27 +a 14 700 Arial
    did -i $dname 5 1 bmpsize 32 32
    did -i $dname 5 1 setimage icon normal $noqt($DC.Imgs(BackUp.ico))
    did -a $dname 5 +a 1 $chr(9) $+ Backup and Restore
    did -b $dname 2,5
    if (!$isdir($DC.Dir(BackUp))) { .mkdir $DC.Dir(BackUp) }
    .timer.Open.B 0 1 /Open.Go.Button
    if ($_B.Reads(X,Last) == $null) { did -a $dname 13 There is no BackUp files. }
    else { did -a $dname 13 Latest Backup files created at: $_B.Reads(X,Last) }
    did -a $dname 3 Main Settings
    did -a $dname 3 Protections
    did -a $dname 3 Members
    did -a $dname 3 Extra Settings
    did -a $dname 3 Seen System
    did -a $dname 3 IRCop Settings
    did -a $dname 3 Conn. Manager
    did -a $dname 3 Top10 Database
    did -a $dname 3 Talk Bot
    did -a $dname 3 mIRC Settings
    did -a $dname 3 Statusbar Settings
    did -b $dname 8,11
    if ($_B.Reads(Settings,Mode) == Custom) {
      did -c $dname 24
      if ($_B.Reads(Settings,Main) == 1) did -s $dname 3 1
      if ($_B.Reads(Settings,Pro) == 1) did -s $dname 3 2
      if ($_B.Reads(Settings,Member) == 1) did -s $dname 3 3
      if ($_B.Reads(Settings,Extra) == 1) did -s $dname 3 4
      if ($_B.Reads(Settings,Seen) == 1) did -s $dname 3 5
      if ($_B.Reads(Settings,IRCop) == 1) did -s $dname 3 6
      if ($_B.Reads(Settings,Connections) == 1) did -s $dname 3 7
      if ($_B.Reads(Settings,Top) == 1) did -s $dname 3 8
      if ($_B.Reads(Settings,Talk) == 1) did -s $dname 3 9
      if ($_B.Reads(Settings,mIRC) == 1) did -s $dname 3 10
      if ($_B.Reads(Settings,SB) == 1) did -s $dname 3 11
    }
    else {
      did -c $dname 25
      var %x = 1
      while (%x <= 11) { did -s $dname 3 %x | inc %x }
    }
    DC.BU.Res.Combo
  }
  if ($devent == sclick) { 
    if ($did == 3) {
      if ($did(3,1).cstate == 1) && ($did(3,2).cstate == 1) && ($did(3,3).cstate == 1) && ($did(3,4).cstate == 1) && ($did(3,5).cstate == 1) && ($did(3,6).cstate != 1) && ($did(3,7).cstate == 1) && ($did(3,8).cstate == 1) && ($did(3,9).cstate == 1) && ($did(3,10).cstate == 1) && ($did(3,11).cstate == 1) {
        did -u $dname 24
        did -c $dname 25
      }
      else { did -u $dname 25 | did -c $dname 24 }
    }
    if ($did == 7) { dialog -c DC.BackUp }
    if ($did == 8) {
      Backup.Save
      did -hb $dname 3,4,8,24,25
      did -ve $dname 9,10,11,13,26
      if ($_B.Reads(X,Last) == $null) { did -b $dname 10 }
    }
    if ($did == 9) { 
      Close.All.Dialogs
      did -b $dname 7,9,10,11,26
      did -ra $dname 13 Checking Script Settings...
      did -ve $dname 12,14
      .timer.Cb 1 1 /Check.Sort C
    }
    if ($did == 10) {
      if ($did(26).seltext == $null) { .echo -aq $input(You should select one from 'Restore Combo' to Restore it!,oi8vg,No Backup Point Given!) | halt }
      if ($isdir($DC.Dir(BackUp\ $+ $did(26).seltext)) != $true) { .echo -aq $input(The Script couldn't found that folder!,oi8vg,Missing Files!) | DC.BU.Removing $did(26).seltext | halt }
      else {
        set %BU.Res $did(26).seltext
        Close.All.Dialogs
        did -b $dname 7,9,10,11,26
        did -ra $dname 13 Attempting To Restoring Settings...
        did -ve $dname 12,14
        .timer.Cb 1 1 /Check.Sort R
      }
    }
    if ($did == 11) { did -ve $dname 3,4,8,24,25 | did -hb $dname 9,10,13,26 | did -b $dname 11 }
    if ($did == 21) { dialog -c DC.BackUp }
    if ($did == 23) {
      Close.All.Dialogs
      set -u8 %Replace.BackUp ON
      did -hb $dname 7,9,10,11,14,15,16,17,18,19,20,21,22,23,26
      did -ra $dname 13 Replacing BackUp...
      .timer.x 1 1 /did -ra $dname 13 Check Script Settings...
      did -ve $dname 12,14
      .timer.Cb 1 2 /Check.Sort C
    }
    if ($did == 25) {
      var %x = 1
      while (%x <= 11) { did -s $dname 3 %x | inc %x }
    }
  }
}
